#!/bin/ash

set -e

DEBIAN_MIRROR_URL=http://ftp.debian.org/debian
CDEBOOTSTRAP_PACKAGE_VERSION=0.6.4_i386
SHA1SUM_SOURCE_URL=ftp://ftp.gnupg.org/gcrypt/binary/sha1sum.c
DEBIAN_CHROOT=/home/root/debian
DEBIAN_DIST=jessie

if [ -e $DEBIAN_CHROOT ]; then
  echo $DEBIAN_CHROOT exists already
  exit 1
fi

if [ -d /tmp/debootstrap-bin/ ]; then
  rm -r /tmp/debootstrap-bin/
fi

mkdir /tmp/debootstrap-bin/
cd /tmp/debootstrap-bin

wget -q http://http.us.debian.org/debian/pool/main/c/cdebootstrap/cdebootstrap-static_0.6.4_i386.deb

ar -x cdebootstrap-static_*

tar xOf data.tar.xz ./usr/lib/cdebootstrap/cdebootstrap_$CDEBOOTSTRAP_PACKAGE_VERSION.tar.gz > cdebootstrap_$CDEBOOTSTRAP_PACKAGE_VERSION.tar.gz

tar xzf cdebootstrap_$CDEBOOTSTRAP_PACKAGE_VERSION.tar.gz

wget -q $SHA1SUM_SOURCE_URL
cc -O3 -o sha1sum sha1sum.c

PATH=/tmp/debootstrap-bin/:$PATH ./cdebootstrap --allow-unauthenticated $DEBIAN_DIST $DEBIAN_CHROOT $DEBIAN_MIRROR_URL

rm -r $DEBIAN_CHROOT/dev/*

mkdir $DEBIAN_CHROOT/dev/pts